/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.util.HashMap;
import java.util.Set;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;

public class AttributeCache {
    private HashMap<ReferenceObject, String> cache = null;
    private MultiSortElemProperties sorter;
    private Concept concept = null;
    private Relationship relationship = null;
    private static final ReferenceObject[] ref_empty_array = new ReferenceObject[0];

    public AttributeCache(MultiSortElemProperties sorter) {
        this.sorter = sorter;
        this.concept = sorter.getConcept();
        int size = this.concept.getObjects().size();
        this.cache = new HashMap(size);
        if (!sorter.getDimension().getConcept().equals(sorter.getConcept())) {
            this.relationship = CoreUtils.getRelationship((Concept)sorter.getConcept(), (Concept)sorter.getDimension().getConcept());
        }
    }

    public String getString(ReferenceObject ro) {
        if (this.cache.containsKey(ro)) {
            return this.cache.get(ro);
        }
        if (ReferenceObject.NULL.equals(ro) || ReferenceObject.UNKNOWN.equals(ro)) {
            this.cache.put(ro, "zzzzzzzzzzzzzz");
            return "zzzzzzzzzzzzzz";
        }
        Concept actual_concept = ro.getConcept();
        if (this.relationship == null) {
            String result = null;
            result = actual_concept.equals(this.concept) ? CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)this.sorter.getAttribute(), (String)Activator.getLanguage()) : CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)actual_concept.getNameAttribute(), (String)Activator.getLanguage());
            this.cache.put(ro, result);
            return result;
        }
        if (this.relationship.getParentConcept().equals(actual_concept)) {
            String result = CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)this.sorter.getAttribute(), (String)Activator.getLanguage());
            this.cache.put(ro, result);
            return result;
        }
        if (this.relationship.getChildConcept().equals(actual_concept)) {
            Set parents = this.relationship.getParents(ro);
            if (parents.size() > 0) {
                ReferenceObject parent = parents.toArray(ref_empty_array)[0];
                String result = CoreUtils.getAttributeTextualValue((ReferenceObject)parent, (Attribute)this.sorter.getAttribute(), (String)Activator.getLanguage());
                this.cache.put(ro, result);
                return result;
            }
            this.cache.put(ro, "");
            return "";
        }
        String result = CoreUtils.getAttributeTextualValue((ReferenceObject)ro, (Attribute)actual_concept.getNameAttribute(), (String)Activator.getLanguage());
        this.cache.put(ro, result);
        return result;
    }

    public void reset() {
        this.cache.clear();
    }
}

