/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.beans.Beans;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.FSActions;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.CalculationTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.DimensionTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.ObservationTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedComparator;
import org.fao.fi.fishstat.gui.views.multitable.UnifiedSelectionProvider;

public class MultiTableView
extends ViewPart
implements Observer,
IPropertyChangeListener,
IFSActions {
    protected static final int KEY_VIEW = 1;
    protected static final int OBS_VIEW = 2;
    protected static final int CLC_VIEW = 3;
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.multitable";
    private SashForm sashForm;
    private DimensionTableViewer keyTableViewer;
    private ObservationTableViewer obsTableViewer;
    private CalculationTableViewer clcTableViewer;
    private Composite compositeLeft;
    private Composite compositeCenter;
    private Composite compositeRight;
    private int[] sashWeigts;
    private GuiSession session;
    private boolean showLastPeriodOnNextRefresh;
    private MenuManager menuMgr;
    private ISelection currentSelection = null;
    private UnifiedComparator advancedSortComparator;
    private ViewerComparator currentComparator = null;

    public void createPartControl(Composite parent) {
        this.session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        this.session.addObserver((Observer)this);
        this.setPartName(this.composePartName());
        this.setTitleToolTip(CoreUtils.getCurrentLang((MultilingualString)this.session.getTimeseries().getDescription(), (String)Activator.getLanguage()));
        this.advancedSortComparator = new UnifiedComparator(this.session.getTimeseriesProperties());
        this.designSashForm(parent);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        GridLayout gl_compositeLeft = new GridLayout(1, false);
        gl_compositeLeft.horizontalSpacing = 1;
        gl_compositeLeft.marginHeight = 0;
        gl_compositeLeft.marginWidth = 0;
        gl_compositeLeft.verticalSpacing = 0;
        this.compositeLeft.setLayout((Layout)gl_compositeLeft);
        if (!Beans.isDesignTime()) {
            this.keyTableViewer = new DimensionTableViewer(this.compositeLeft, 268501762, this.session);
        }
        final Table keyTable = this.keyTableViewer.getTable();
        keyTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        keyTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int topIndex = keyTable.getTopIndex();
                MultiTableView.this.obsTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.clcTableViewer.getTable().setTopIndex(topIndex);
            }
        });
        keyTable.setHeaderVisible(true);
        this.keyTableViewer.setUseHashlookup(true);
        GridLayout gl_compositeCenter = new GridLayout(1, false);
        gl_compositeCenter.verticalSpacing = 0;
        gl_compositeCenter.marginWidth = 0;
        gl_compositeCenter.marginHeight = 0;
        gl_compositeCenter.horizontalSpacing = 1;
        this.compositeCenter.setLayout((Layout)gl_compositeCenter);
        this.obsTableViewer = new ObservationTableViewer(this.compositeCenter, 268501762, this.session);
        final Table obsTable = this.obsTableViewer.getTable();
        obsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        obsTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int topIndex = obsTable.getTopIndex();
                MultiTableView.this.keyTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.clcTableViewer.getTable().setTopIndex(topIndex);
            }
        });
        this.obsTableViewer.setUseHashlookup(true);
        GridLayout gl_compositeRight = new GridLayout(1, false);
        gl_compositeRight.marginWidth = 0;
        gl_compositeRight.verticalSpacing = 0;
        gl_compositeRight.marginHeight = 0;
        gl_compositeRight.horizontalSpacing = 1;
        this.compositeRight.setLayout((Layout)gl_compositeRight);
        this.clcTableViewer = new CalculationTableViewer(this.compositeRight, 268501762, this.session);
        final Table clcTable = this.clcTableViewer.getTable();
        clcTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        clcTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int topIndex = clcTable.getTopIndex();
                MultiTableView.this.keyTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.obsTableViewer.getTable().setTopIndex(topIndex);
            }
        });
        this.clcTableViewer.setUseHashlookup(true);
        this.keyTableViewer.addParallelTable(this.obsTableViewer);
        this.keyTableViewer.addParallelTable(this.clcTableViewer);
        this.obsTableViewer.addParallelTable(this.keyTableViewer);
        this.obsTableViewer.addParallelTable(this.clcTableViewer);
        this.clcTableViewer.addParallelTable(this.keyTableViewer);
        this.clcTableViewer.addParallelTable(this.obsTableViewer);
        this.menuMgr = new MenuManager();
        Control control1 = this.keyTableViewer.getControl();
        Menu menu1 = this.menuMgr.createContextMenu(control1);
        control1.setMenu(menu1);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.obsTableViewer);
        Control control2 = this.obsTableViewer.getControl();
        Menu menu2 = this.menuMgr.createContextMenu(control2);
        control2.setMenu(menu2);
        this.getSite().setSelectionProvider((ISelectionProvider)new UnifiedSelectionProvider((ISelectionProvider)this.keyTableViewer, (ISelectionProvider)this.obsTableViewer, (ISelectionProvider)this.clcTableViewer));
        this.initializeToolBar();
        this.resizeSashWeights();
        this.setCommonComparator(new UnifiedComparator(this.session.getTimeseriesProperties()));
    }

    private void designSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 0);
        this.compositeLeft = new Composite((Composite)this.sashForm, 0);
        this.compositeLeft.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                int topIndex = MultiTableView.this.keyTableViewer.getTable().getTopIndex();
                MultiTableView.this.obsTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.clcTableViewer.getTable().setTopIndex(topIndex);
                MultiTableView.this.keyTableViewer.getTable().getHorizontalBar().setVisible(true);
                MultiTableView.this.keyTableViewer.getTable().layout(true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.compositeCenter = new Composite((Composite)this.sashForm, 0);
        this.compositeRight = new Composite((Composite)this.sashForm, 0);
    }

    public void setCommonComparator(final ViewerComparator c) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MultiTableView.this.keyTableViewer.setComparator(c);
                MultiTableView.this.obsTableViewer.setComparator(c);
                MultiTableView.this.clcTableViewer.setComparator(c);
            }
        });
    }

    public void resetSort() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MultiTableView.this.keyTableViewer.resetSortColumn();
                MultiTableView.this.obsTableViewer.resetSortColumn();
                MultiTableView.this.clcTableViewer.resetSortColumn();
            }
        });
    }

    public void setFocus() {
        this.keyTableViewer.getTable().setFocus();
        int index = this.keyTableViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            Activator.getDefault().getStatusBarController().setRecordNumber(index);
        } else {
            Activator.getDefault().getStatusBarController().cleanRecordNumber();
        }
        Activator.getDefault().getStatusBarController().setTotalRecords(this.session.getLastResultSize());
        Activator.getDefault().getStatusBarController().setUnit(this.session.getUnitValue());
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    public GuiSession getSession() {
        return this.session;
    }

    private void allTablesRefresh() {
        this.keyTableViewer.setInput(this.session);
        this.obsTableViewer.setInput(this.session);
        if (this.sashForm.getChildren()[2].isVisible()) {
            this.clcTableViewer.setInput(this.session);
            this.clcTableViewer.refresh(true);
        }
        Activator.getDefault().getStatusBarController().cleanRecordNumber();
    }

    private void resizeSashWeights() {
        int key_widht = this.keyTableViewer.getColumnsTotalWidth() + 20;
        int clc_width = this.clcTableViewer.getColumnsTotalWidth() + 20;
        int glo_widht = PlatformUI.getWorkbench().getDisplay().getClientArea().width;
        this.sashWeigts = new int[]{key_widht, glo_widht - key_widht - clc_width, clc_width};
        this.sashAdjoust(this.sashWeigts);
    }

    private void sashAdjoust(int[] measures) {
        this.sashForm.setWeights(this.sashWeigts);
        this.sashForm.getChildren()[2].setVisible(this.session.hasCalculatedMesaures());
        this.sashForm.layout(true);
    }

    public void showLastPeriodOnNextRefresh() {
        this.showLastPeriodOnNextRefresh = true;
    }

    public void dispose() {
        this.session.deleteObserver((Observer)this);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (GuiCoreActivator.getDefault().getRegistry().existSession(this.session.getDescriptor())) {
            GuiCoreActivator.getDefault().getRegistry().closeSession((Session)this.session);
        }
        this.session = null;
        super.dispose();
    }

    public DimensionTableViewer getKeyTableViewer() {
        return this.keyTableViewer;
    }

    public ObservationTableViewer getObsTableViewer() {
        return this.obsTableViewer;
    }

    public CalculationTableViewer getClcTableViewer() {
        return this.clcTableViewer;
    }

    public boolean hasClcTableViewer() {
        return this.clcTableViewer != null;
    }

    private String composePartName() {
        StringBuffer sb = new StringBuffer();
        sb.append(CoreUtils.getCurrentLang((MultilingualString)this.session.getDataset().getName(), (String)Activator.getLanguage()));
        sb.append(" - ");
        sb.append(CoreUtils.getCurrentLang((MultilingualString)this.session.getTimeseries().getName(), (String)Activator.getLanguage()));
        return sb.toString();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        if (!this.isDisposed() && (property = event.getProperty()).startsWith("display.")) {
            if (property.equals("display.fixed.columns.width")) {
                this.obsTableViewer.rebuildTable();
            }
            this.obsTableViewer.setInput(this.session);
            if (this.sashForm.getChildren()[2].isVisible()) {
                this.clcTableViewer.setInput(this.session);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.equals("VIEW_FLUSH")) {
            this.forcedClean();
        } else if (arg.equals("REFRESH")) {
            this.allTablesRefresh();
        } else if (arg instanceof FocusEntity) {
            this.refreshDynamicMenus((FocusEntity)arg);
        } else if (arg instanceof FSActions) {
            this.refreshViews((FSActions)arg);
        }
    }

    public void forcedClean() {
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MultiTableView.this.keyTableViewer.setItemCount(0);
                MultiTableView.this.obsTableViewer.setItemCount(0);
                MultiTableView.this.clcTableViewer.setItemCount(0);
                System.gc();
            }
        });
    }

    private void refreshViews(FSActions arg) {
        final Integer[] actions = arg.toArray();
        Display display = Display.getDefault();
        Activator.getDefault().getStatusBarController().setUnit(this.session.getUnitValue());
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MultiTableView.this.currentSelection = MultiTableView.this.keyTableViewer.getSelection();
                MultiTableView.this.currentComparator = MultiTableView.this.keyTableViewer.getComparator();
                MultiTableView.this.setCommonComparator(null);
                Integer[] integerArray = actions;
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer action = integerArray[n2];
                    switch (action) {
                        case 21: {
                            MultiTableView.this.keyTableViewer.rebuildTable();
                            MultiTableView.this.resizeSashWeights();
                            break;
                        }
                        case 22: {
                            MultiTableView.this.obsTableViewer.rebuildTable();
                            MultiTableView.this.resizeSashWeights();
                            break;
                        }
                        case 23: {
                            MultiTableView.this.clcTableViewer.rebuildTable();
                            MultiTableView.this.resizeSashWeights();
                            break;
                        }
                        case 81: {
                            MultiTableView.this.keyTableViewer.adjournColumnsHeaders(true);
                            break;
                        }
                        case 82: {
                            MultiTableView.this.obsTableViewer.adjournColumnsHeaders(false);
                            break;
                        }
                        case 83: {
                            MultiTableView.this.clcTableViewer.adjournColumnsHeaders(false);
                            break;
                        }
                        case 91: {
                            MultiTableView.this.keyTableViewer.refresh(true);
                            Activator.getDefault().getStatusBarController().cleanRecordNumber();
                            break;
                        }
                        case 92: {
                            MultiTableView.this.obsTableViewer.refresh(true);
                            Activator.getDefault().getStatusBarController().cleanRecordNumber();
                            break;
                        }
                        case 93: {
                            MultiTableView.this.clcTableViewer.refresh(true);
                            Activator.getDefault().getStatusBarController().cleanRecordNumber();
                            break;
                        }
                        case 42: {
                            MultiTableView.this.setCommonComparator(MultiTableView.this.currentComparator);
                            break;
                        }
                        case 41: {
                            MultiTableView.this.advancedSortComparator.clearCache();
                            MultiTableView.this.setCommonComparator(MultiTableView.this.advancedSortComparator);
                            break;
                        }
                        case 43: {
                            MultiTableView.this.resetSort();
                            break;
                        }
                    }
                    ++n2;
                }
                MultiTableView.this.allTablesRefresh();
                if (MultiTableView.this.showLastPeriodOnNextRefresh) {
                    MultiTableView.this.obsTableViewer.getTable().showColumn(MultiTableView.this.obsTableViewer.getTable().getColumn(MultiTableView.this.obsTableViewer.getTable().getColumnCount() - 1));
                    MultiTableView.this.showLastPeriodOnNextRefresh = false;
                }
                MultiTableView.this.keyTableViewer.setSelection(MultiTableView.this.currentSelection);
            }
        });
        Activator.getDefault().getStatusBarController().setTotalRecords(this.session.getCurrentFilterSize());
    }

    private void refreshDynamicMenus(FocusEntity entity) {
    }

    public boolean isDisposed() {
        return this.session == null;
    }
}

