/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2e.model.edit.pom.Configuration;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.PomPackage;
import org.eclipse.m2e.model.edit.pom.translators.ConfigurationAdapter;
import org.eclipse.m2e.model.edit.pom.translators.ListAdapter;
import org.eclipse.m2e.model.edit.pom.translators.PropertiesAdapter;
import org.eclipse.m2e.model.edit.pom.translators.SSESyncResource;
import org.eclipse.m2e.model.edit.pom.translators.TranslatorAdapter;
import org.eclipse.m2e.model.edit.pom.translators.ValueUpdateAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelObjectAdapter
extends TranslatorAdapter
implements Adapter,
INodeAdapter {
    private SSESyncResource resource;
    private EObject eobject;
    private Notifier target;
    private Map<EStructuralFeature, TranslatorAdapter> childAdapters = new LinkedHashMap<EStructuralFeature, TranslatorAdapter>();

    public ModelObjectAdapter(SSESyncResource resource, EObject eobject, Element node) {
        super(resource);
        this.eobject = eobject;
        this.node = node;
        this.resource = resource;
    }

    public boolean isAdapterForType(Object type) {
        return ModelObjectAdapter.class.equals(type);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.resource.isProcessEvents()) {
            this.resource.setProcessEvents(false);
            try {
                if (2 == eventType && newValue instanceof Element) {
                    if (notifier == this.node) {
                        IDOMElement addedElement = (IDOMElement)newValue;
                        EStructuralFeature feature = this.eobject.eClass().getEStructuralFeature(addedElement.getLocalName());
                        if (feature != null) {
                            this.createOrGetChildAdapter(feature).load();
                        }
                    }
                } else if (3 == eventType && oldValue instanceof Element && notifier == this.node) {
                    IDOMElement removedElement = (IDOMElement)oldValue;
                    EStructuralFeature feature = this.eobject.eClass().getEStructuralFeature(removedElement.getLocalName());
                    if (feature != null) {
                        this.eobject.eUnset(feature);
                        this.childAdapters.remove(feature);
                    }
                }
            }
            finally {
                this.resource.setProcessEvents(true);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.resource.isProcessEvents()) {
            this.resource.setProcessEvents(false);
            try {
                EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                switch (notification.getEventType()) {
                    case 1: {
                        if (notification.getNewValue() == null || "".equals(notification.getNewValue())) {
                            this.removeDomChild(feature);
                            break;
                        }
                        TranslatorAdapter setAdapter = this.createOrGetChildAdapter(feature);
                        setAdapter.update(notification.getOldValue(), notification.getNewValue(), notification.getPosition());
                        break;
                    }
                    case 3: {
                        ListAdapter addListAdapter = (ListAdapter)this.createOrGetChildAdapter(feature);
                        addListAdapter.add(notification.getNewValue(), notification.getPosition());
                        break;
                    }
                    case 5: {
                        int addPosition;
                        ListAdapter addManyListAdapter = (ListAdapter)this.createOrGetChildAdapter(feature);
                        Collection addMany = (Collection)notification.getNewValue();
                        int addIdx = addPosition = notification.getPosition();
                        for (Object object : addMany) {
                            addManyListAdapter.add(object, addPosition == -1 ? -1 : addIdx);
                            ++addIdx;
                        }
                        break;
                    }
                    case 4: {
                        ListAdapter removeListAdapter = (ListAdapter)this.createOrGetChildAdapter(feature);
                        removeListAdapter.remove(notification.getOldValue(), notification.getPosition());
                        break;
                    }
                    case 2: {
                        this.removeDomChild(feature);
                        break;
                    }
                    case 6: {
                        int removePosition;
                        ListAdapter removeManyListAdapter = (ListAdapter)this.createOrGetChildAdapter(feature);
                        Collection removeMany = (Collection)notification.getOldValue();
                        int removeIdx = removePosition = notification.getPosition();
                        for (Object object : removeMany) {
                            removeManyListAdapter.remove(object, removePosition == -1 ? -1 : removeIdx);
                            ++removeIdx;
                        }
                    }
                }
            }
            finally {
                this.resource.setProcessEvents(true);
            }
        }
    }

    @Override
    public void update(Object oldValue, Object newValObject, int index) {
        this.save();
    }

    private TranslatorAdapter createOrGetChildAdapter(EStructuralFeature feature) {
        TranslatorAdapter ret = this.childAdapters.get(feature);
        if (ret == null) {
            Element element = this.getFirstChildWithName(this.node, feature.getName());
            boolean isNew = false;
            if (element == null) {
                element = this.node.getOwnerDocument().createElement(feature.getName());
                this.insertElement(element);
                isNew = true;
            }
            if (feature.isMany()) {
                EClass elementType = null;
                if (feature instanceof EReference) {
                    elementType = ((EReference)feature).getEReferenceType();
                }
                ret = elementType != null && elementType.getClassifierID() == PomPackage.Literals.PROPERTY_ELEMENT.getClassifierID() ? new PropertiesAdapter(this.resource, element, (List)this.eobject.eGet(feature)) : new ListAdapter(this.resource, element, (List)this.eobject.eGet(feature), elementType);
            } else if (feature instanceof EReference) {
                EClass elementType;
                EReference ref = (EReference)feature;
                EObject eo = (EObject)this.eobject.eGet(feature);
                if (eo == null) {
                    eo = PomFactory.eINSTANCE.create(ref.getEReferenceType());
                    this.eobject.eSet((EStructuralFeature)ref, (Object)eo);
                }
                if ((elementType = ref.getEReferenceType()) != null && elementType.getClassifierID() == PomPackage.Literals.CONFIGURATION.getClassifierID()) {
                    ret = new ConfigurationAdapter(this.resource, element, (Configuration)this.eobject.eGet(feature));
                } else {
                    ret = new ModelObjectAdapter(this.resource, eo, element);
                    ((ModelObjectAdapter)ret).eobject.eAdapters().add((Object)((ModelObjectAdapter)ret));
                }
            } else {
                ret = new ValueUpdateAdapter(this.resource, element, this.eobject, feature);
            }
            if (isNew) {
                this.formatNode(element);
            }
            ((IDOMElement)element).addAdapter((INodeAdapter)ret);
            this.childAdapters.put(feature, ret);
        }
        return ret;
    }

    private void removeDomChild(EStructuralFeature feature) {
        TranslatorAdapter ta = this.childAdapters.get(feature);
        if (ta != null && ta.getNode() != null) {
            this.removeChildElement(ta.getNode());
        }
        this.childAdapters.remove(feature);
    }

    private void insertElement(Element element) {
        Node beforeNode = null;
        boolean searching = false;
        for (EStructuralFeature feature : this.eobject.eClass().getEStructuralFeatures()) {
            if (element.getLocalName().equals(feature.getName())) {
                searching = true;
            }
            if (searching && (beforeNode = this.getFirstChildWithName(this.node, feature.getName())) != null) break;
        }
        if (beforeNode == null) {
            beforeNode = this.node.getLastChild();
            while (beforeNode != null && !(beforeNode.getPreviousSibling() instanceof Element) && beforeNode.getPreviousSibling() != null) {
                beforeNode = beforeNode.getPreviousSibling();
            }
        }
        if (beforeNode == null) {
            this.node.appendChild(element);
        } else {
            this.node.insertBefore(element, beforeNode);
        }
    }

    @Override
    public void load() {
        NodeList children = this.node.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node child = children.item(i);
            if (child instanceof Element) {
                Element element = (Element)child;
                EStructuralFeature feature = this.eobject.eClass().getEStructuralFeature(element.getLocalName());
                if (feature != null) {
                    this.createOrGetChildAdapter(feature).load();
                }
            }
            ++i;
        }
    }

    @Override
    public void save() {
        for (EStructuralFeature feature : this.eobject.eClass().getEStructuralFeatures()) {
            Object o;
            if (!this.eobject.eIsSet(feature) || "".equals(o = this.eobject.eGet(feature)) || o == null) continue;
            this.createOrGetChildAdapter(feature).save();
        }
    }

    public Notifier getTarget() {
        return this.target;
    }

    public void setTarget(Notifier target) {
        this.target = target;
    }
}

