/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.WidgetsUtils;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;

public class ReferenceList
extends Composite
implements Observer {
    private String lang;
    private ConceptProperties displayProperties;
    private ListViewer viewer;
    private CLabel lblTitle;
    private Text txtFilter;
    private Button btnNewButton;
    private static final Color WHITE_COLOR = SWTResourceManager.getColor(255, 255, 255);
    private static final Color VERY_LIGTH_CYAN = SWTResourceManager.getColor(245, 253, 255);

    public ReferenceList(Composite parent, int style, ConceptProperties p, String lang) {
        super(parent, 0);
        this.lang = lang;
        this.displayProperties = p;
        this.displayProperties.getDimensionProperties().addObserver((Observer)this);
        this.initComponents();
    }

    private void initComponents() {
        this.createLayout();
        this.createTitleLabel();
        this.txtFilter = new Text((Composite)this, 2048);
        this.txtFilter.setToolTipText(ComponentsActivator.getDefault().getLocalString("label.search.specific.item"));
        this.txtFilter.setForeground(SWTResourceManager.getColor(10));
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReferenceList.this.viewer.refresh(true);
                if (ReferenceList.this.txtFilter.getText() == null || ReferenceList.this.txtFilter.getText().equals("")) {
                    ReferenceList.this.txtFilter.setBackground(WHITE_COLOR);
                    ReferenceList.this.viewer.getControl().setBackground(WHITE_COLOR);
                } else {
                    ReferenceList.this.txtFilter.setBackground(VERY_LIGTH_CYAN);
                    ReferenceList.this.viewer.getControl().setBackground(VERY_LIGTH_CYAN);
                }
            }
        });
        GridData gd_text = new GridData(4, 4, true, false, 1, 1);
        gd_text.heightHint = 14;
        gd_text.widthHint = 376;
        this.txtFilter.setLayoutData((Object)gd_text);
        this.btnNewButton = new Button((Composite)this, 0x1000002);
        this.btnNewButton.setToolTipText(ComponentsActivator.getDefault().getLocalString("label.search.mode"));
        this.btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceList.this.btnNewButton.setText(ReferenceList.this.btnNewButton.getSelection() ? "..A." : "A...");
                ReferenceList.this.viewer.refresh(true);
            }
        });
        GridData gd_btnNewButton = new GridData(4, 4, false, false, 1, 1);
        gd_btnNewButton.widthHint = 42;
        gd_btnNewButton.heightHint = 16;
        this.btnNewButton.setLayoutData((Object)gd_btnNewButton);
        this.btnNewButton.setText("A...");
        this.viewer = new ListViewer((Composite)this, 2562);
        final org.eclipse.swt.widgets.List list = this.viewer.getList();
        list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int row = WidgetsUtils.getListRowCell(list, e);
                ReferenceObject ro = null;
                if (row >= 0) {
                    ro = (ReferenceObject)ReferenceList.this.viewer.getElementAt(row);
                }
                list.setData("lastRigthClick", ro);
            }
        });
        GridData gd_list_2 = new GridData(4, 4, true, true);
        gd_list_2.horizontalSpan = 3;
        gd_list_2.heightHint = 368;
        gd_list_2.widthHint = 104;
        this.viewer.getList().setLayoutData((Object)gd_list_2);
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ValueLabelProvider());
        this.viewer.setComparator((ViewerComparator)new refObjectSorter());
        this.viewer.setFilters((ViewerFilter[])new ReferenceObjectsFilter[]{new ReferenceObjectsFilter()});
        GridData gd_list_1 = new GridData(4, 4, true, true);
        gd_list_1.widthHint = 116;
        GridData gd_list = new GridData(16384, 0x1000000, false, true);
        gd_list.heightHint = 372;
        gd_list.widthHint = 230;
        GridData gd_filteredList = new GridData(16384, 0x1000000, true, true);
        gd_filteredList.heightHint = 382;
        gd_filteredList.widthHint = 230;
    }

    public void setType(String type) {
        if (type.equals("include") || type.equals("exclude")) {
            this.viewer.setData("context", (Object)type);
        } else {
            this.viewer.setData("context", null);
        }
    }

    private void createLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    private void createTitleLabel() {
        this.lblTitle = new CLabel((Composite)this, 0x1000000);
        this.lblTitle.setFont(ComponentsCommons.getFont("", 11, 1));
        this.lblTitle.setBackground(ComponentsCommons.getColor(1));
        GridData gd_lblTitle = new GridData(4, 4, true, false);
        gd_lblTitle.horizontalSpan = 3;
        gd_lblTitle.widthHint = 60;
        this.lblTitle.setLayoutData((Object)gd_lblTitle);
        this.lblTitle.setText(ComponentsActivator.getDefault().getLocalString("label.title.first.upper"));
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setTitle(String title) {
        this.lblTitle.setText(title);
        this.viewer.setData("title", (Object)title);
    }

    public Color getTitleColor() {
        return this.lblTitle.getForeground();
    }

    public void setTitleColor(Color color) {
        this.lblTitle.setForeground(color);
    }

    public void setInput(Observable input) {
        if (this.viewer != null && this.viewer.getContentProvider() != null && input != null) {
            this.viewer.setInput((Object)input);
        }
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    public LinkedList<ReferenceObject> getSelectionPrevious(LinkedList<ReferenceObject> selectedROs) {
        if (selectedROs.size() == 0 || this.viewer.getList().getItemCount() < 2 || this.viewer.getList().getItemCount() <= selectedROs.size()) {
            return null;
        }
        ReferenceObject selectedRO = selectedROs.getFirst();
        int i = 0;
        while (i < this.viewer.getList().getItemCount()) {
            if (selectedRO.equals((ReferenceObject)this.viewer.getElementAt(i))) {
                LinkedList<ReferenceObject> previousRO = new LinkedList<ReferenceObject>();
                if (i >= 1) {
                    previousRO.add((ReferenceObject)this.viewer.getElementAt(i - 1));
                } else {
                    previousRO.add((ReferenceObject)this.viewer.getElementAt(1));
                }
                return previousRO;
            }
            ++i;
        }
        return null;
    }

    public void setSelection(List<ReferenceObject> in) {
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.setSelection((ISelection)new StructuredSelection(in));
        if (in.size() >= 1) {
            this.viewer.reveal((Object)in.get(0));
        }
    }

    public void setForegroundListColor(Color color) {
        this.viewer.getList().setForeground(color);
    }

    public void setContentProvider(IContentProvider provider) {
        this.viewer.setContentProvider(provider);
    }

    public IContentProvider getContentProvider() {
        return this.viewer.getContentProvider();
    }

    public ListViewer getViewer() {
        return this.viewer;
    }

    public Set<ReferenceObject> getSelectedItems() {
        StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
        return new HashSet<ReferenceObject>(sel.toList());
    }

    public ConceptProperties getDisplayProperties() {
        return this.displayProperties;
    }

    public void setDisplayProperties(ConceptProperties displayProperties) {
        this.displayProperties = displayProperties;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }

    class ReferenceObjectsFilter
    extends ViewerFilter {
        ReferenceObjectsFilter() {
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (ReferenceList.this.txtFilter.getText() == null || ReferenceList.this.txtFilter.getText().equals("")) {
                return true;
            }
            Object attVal = ((ReferenceObject)arg2).getAttribute(ReferenceList.this.displayProperties.getAttribute());
            String value = attVal instanceof MultilingualString ? ((MultilingualString)attVal).getValue(ReferenceList.this.lang) : attVal.toString();
            return ReferenceList.this.btnNewButton.getSelection() ? value.contains(ReferenceList.this.txtFilter.getText()) : value.startsWith(ReferenceList.this.txtFilter.getText());
        }
    }

    class ValueLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ValueLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ReferenceObject) {
                try {
                    Concept c = ((ReferenceObject)element).getConcept();
                    return c.getAttribute(ReferenceList.this.displayProperties.getAttribute().getAcronym()).getName().getValue(ReferenceList.this.lang);
                }
                catch (ReferenceServiceException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        public String getText(Object element) {
            String result = null;
            try {
                if (element instanceof ReferenceObject && ((result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)ReferenceList.this.displayProperties.getAttribute(), (String)ReferenceList.this.lang)) == null || result.trim().equals("") || result.trim().equals("...")) && ReferenceList.this.displayProperties.hasAlternate()) {
                    result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)ReferenceList.this.displayProperties.getAlternate(), (String)ReferenceList.this.lang);
                }
            }
            catch (ReferenceServiceException e) {
                ComponentsCommons.showExceptionWithStack(e);
            }
            return result;
        }
    }

    class refObjectSorter
    extends ViewerComparator {
        refObjectSorter() {
        }

        public int compare(Viewer viewer, ReferenceObject e1, ReferenceObject e2) {
            try {
                String s1;
                Object ra1 = e1.getAttribute(ReferenceList.this.displayProperties.getAttribute().getAcronym());
                Object ra2 = e2.getAttribute(ReferenceList.this.displayProperties.getAttribute().getAcronym());
                String s2 = null;
                if (ra1 instanceof MultilingualString) {
                    s1 = ((MultilingualString)ra1).getValue(ReferenceList.this.lang);
                    s2 = ((MultilingualString)ra2).getValue(ReferenceList.this.lang);
                } else {
                    s1 = ra1.toString();
                    s2 = ra2.toString();
                }
                int res = s1.compareToIgnoreCase(s2);
                return res;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

