/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.gui.viewers;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptViewersFactory {
    private static ConceptViewersFactory factory;

    private ConceptViewersFactory() {
    }

    public static ConceptViewersFactory getFactory() {
        if (factory == null) {
            factory = new ConceptViewersFactory();
        }
        return factory;
    }

    public StructuredViewer createViewer(Composite parent, int style, Class<?> viewerClass, String lang) {
        if (viewerClass.equals(ComboViewer.class)) {
            return this.createComboViewer(parent, style, lang);
        }
        if (viewerClass.equals(ListViewer.class)) {
            return this.createListViewer(parent, style, lang);
        }
        return null;
    }

    private ComboViewer createComboViewer(Composite parent, int style, String lang) {
        ComboViewer result = new ComboViewer(parent, style);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private ListViewer createListViewer(Composite parent, int style, String lang) {
        ListViewer result = new ListViewer(parent, style);
        result.setContentProvider((IContentProvider)new ConceptsContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new ConceptsLabelProvider(lang));
        result.setComparator((ViewerComparator)new ConceptsSorter(lang));
        return result;
    }

    private class ConceptsContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ReferenceServiceFactory.getService().getConcepts().toArray();
        }
    }

    private class ConceptsLabelProvider
    extends LabelProvider {
        private String lang = null;

        public ConceptsLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)this.lang);
            }
            return super.getText(element);
        }
    }

    private class ConceptsSorter
    extends ViewerComparator {
        private String lang;

        public ConceptsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            try {
                if (c1 instanceof Concept && c2 instanceof Concept) {
                    return CoreUtils.getCurrentLangName((Object)c1, (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)c2, (String)this.lang));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}

