/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.beans.Beans;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class DimensionParentsTreeViewer
extends TreeViewer
implements Observer {
    private String lang;
    private DimensionProperties dimensionProperties;
    private boolean dimensionIncluded = false;

    public DimensionParentsTreeViewer(Composite parent, int style, String lang) {
        super(parent, style);
    }

    public DimensionParentsTreeViewer(Composite parent, int style, DimensionProperties dimensionProperties, ITreeContentProvider cp, String lang) {
        super(parent, style + 0x10000000);
        this.dimensionProperties = dimensionProperties;
        this.lang = lang;
        if (!Beans.isDesignTime()) {
            this.init();
            this.setContentProvider((IContentProvider)cp);
            this.setInput((Object)ComponentsActivator.getDefault());
        }
    }

    public DimensionParentsTreeViewer(Composite parent, int style, DimensionProperties dimensionProperties, boolean dimensionIncluded, String lang) {
        super(parent, 0x10000000);
        this.dimensionProperties = dimensionProperties;
        this.lang = lang;
        this.dimensionIncluded = dimensionIncluded;
        if (!Beans.isDesignTime()) {
            this.setContentProvider((IContentProvider)new DimensionParentsContentProvider());
            this.init();
            this.setInput((Object)ComponentsActivator.getDefault());
        }
    }

    public DimensionParentsTreeViewer(Composite parent, int style, DimensionProperties dimensionProperties, boolean dimensionIncluded) {
        super(parent, style | 0x10000000);
        this.dimensionProperties = dimensionProperties;
        this.dimensionIncluded = dimensionIncluded;
        if (!Beans.isDesignTime()) {
            this.setContentProvider((IContentProvider)new DimensionParentsContentProvider());
            this.init();
            this.setInput((Object)ComponentsActivator.getDefault());
        }
    }

    public DimensionParentsTreeViewer(Composite parent, int style, DimensionProperties dimensionProperties, ITreeContentProvider cp) {
        super(parent, style | 0x10000000);
        this.dimensionProperties = dimensionProperties;
        if (!Beans.isDesignTime()) {
            this.setContentProvider((IContentProvider)cp);
            this.init();
        }
    }

    private void init() {
        this.setLabelProvider((IBaseLabelProvider)new DimensionParentsLabelProvider());
        this.setComparator(new DimensionParentsSorter());
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        if (!this.getTree().isDisposed()) {
            this.refresh(true);
        }
    }

    class DimensionParentsContentProvider
    implements ITreeContentProvider {
        DimensionParentsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            try {
                return ((Concept)parentElement).getObjects().toArray();
            }
            catch (ReferenceServiceException e) {
                ComponentsCommons.showExceptionWithStack(e);
                return null;
            }
        }

        public Object getParent(Object element) {
            return ((ReferenceObject)element).getConcept();
        }

        public boolean hasChildren(Object element) {
            return element instanceof Concept;
        }

        public Object[] getElements(Object inputElement) {
            try {
                return CoreUtils.getDimensionParents((Dimension)DimensionParentsTreeViewer.this.dimensionProperties.getDimension(), (boolean)DimensionParentsTreeViewer.this.dimensionIncluded);
            }
            catch (ReferenceServiceException e) {
                ComponentsCommons.showExceptionWithStack(e);
                return new Concept[0];
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class DimensionParentsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private Image conceptImage = ComponentsActivator.getImage("icons/notationsheader.gif");
        private Image robjectImage = ComponentsActivator.getImage("icons/sourceEditor.gif");

        public Image getImage(Object element) {
            if (element instanceof Concept) {
                return this.conceptImage;
            }
            if (element instanceof ReferenceObject) {
                return this.robjectImage;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            String result = null;
            if (element instanceof Concept) {
                result = CoreUtils.getCurrentLangName((Object)element, (String)DimensionParentsTreeViewer.this.lang);
            }
            if (element instanceof ReferenceObject) {
                ConceptProperties cdp = DimensionParentsTreeViewer.this.dimensionProperties.getSelector(((ReferenceObject)element).getConcept().getAcronym());
                try {
                    result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)cdp.getAttribute(), (String)DimensionParentsTreeViewer.this.lang);
                    if ((result == null || result.trim().equals("") || result.trim().equals("...")) && cdp.hasAlternate()) {
                        result = CoreUtils.getAttributeTextualValue((ReferenceObject)((ReferenceObject)element), (Attribute)cdp.getAlternate(), (String)DimensionParentsTreeViewer.this.lang);
                    }
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
            }
            if (element instanceof String) {
                result = (String)element;
            }
            return result;
        }
    }

    private class DimensionParentsSorter
    extends ViewerComparator {
        private DimensionParentsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                if (((Concept)e1).getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                if (((Concept)e2).getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                return CoreUtils.getCurrentLangName((Object)((Concept)e1), (String)DimensionParentsTreeViewer.this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Concept)e2), (String)DimensionParentsTreeViewer.this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

