/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class RangeLimitText
extends Composite {
    private boolean valid;
    private boolean colorize;
    private Double value;
    private Text text;

    public RangeLimitText(Composite parent, int style) {
        super(parent, style);
        this.initComponents();
    }

    public RangeLimitText(Composite parent, int style, boolean colorize) {
        super(parent, style);
        this.colorize = colorize;
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!RangeLimitText.this.validate()) {
                    if (RangeLimitText.this.colorize) {
                        RangeLimitText.this.text.setForeground(ComponentsCommons.getColor(255, 0, 0));
                    }
                } else {
                    RangeLimitText.this.text.setForeground(ComponentsCommons.getColor(0, 0, 0));
                }
            }
        });
    }

    private boolean validate() {
        try {
            this.value = new Double(this.text.getText());
            this.valid = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
        return this.valid;
    }

    public Text getControl() {
        return this.text;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }
}

