/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.util.LinkedList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class RelationComboViewer
extends ComboViewer {
    private String lang;
    private Concept concept = null;
    private boolean parentIncluded = false;

    public RelationComboViewer(Composite parent, int style, Concept c, boolean parentIncluded, String lang) {
        super(parent, 0x10000000 | style);
        this.lang = lang;
        this.concept = c;
        this.setContentProvider((IContentProvider)new DimensionParentsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DimensionParentsLabelProvider(this.lang));
        this.setComparator(new DimensionParentsSorter(this.lang));
        this.parentIncluded = parentIncluded;
        this.setInput(c);
        if (c != null) {
            if (parentIncluded) {
                this.setSelection((ISelection)new StructuredSelection((Object)c));
            } else if (this.getCombo().getItemCount() > 0) {
                this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
            }
        }
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.setInput(concept);
        this.getCombo().redraw();
        this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
    }

    public Concept getSelectedParent() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Concept)sel.getFirstElement();
    }

    private class DimensionParentsContentProvider
    implements IStructuredContentProvider {
        private DimensionParentsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                LinkedList rels = new LinkedList(RelationComboViewer.this.concept.getParentRelationships());
                Object[] res = new Object[rels.size() + (RelationComboViewer.this.parentIncluded ? 1 : 0)];
                int i = 0;
                while (i < rels.size()) {
                    res[i] = ((Relationship)rels.get(i)).getParentConcept();
                    ++i;
                }
                if (RelationComboViewer.this.parentIncluded) {
                    res[i] = RelationComboViewer.this.concept;
                }
                return res;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DimensionParentsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private String lang;

        public DimensionParentsLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)this.lang);
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "#ERROR#";
        }
    }

    private class DimensionParentsSorter
    extends ViewerComparator {
        private String lang;

        public DimensionParentsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                if (((Concept)e1).getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                if (((Concept)e2).getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                return CoreUtils.getCurrentLangName((Object)((Concept)e1), (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Concept)e2), (String)this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

