/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.addons;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.CommandManagerEvent;
import org.eclipse.core.commands.ICommandManagerListener;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Parameter;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CommandProcessingAddon {
    @Inject
    private ECommandService commandService;
    @Inject
    private CommandManager commandManager;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private EModelService modelService;
    private Category undefinedCategory;
    private EventHandler additionHandler;
    private ICommandManagerListener cmListener;

    public static MCommand createCommand(Command cmd, EModelService modelService, MCategory categoryModel) throws NotDefinedException {
        MCommand command = modelService.createModelElement(MCommand.class);
        command.setElementId(cmd.getId());
        command.setCategory(categoryModel);
        command.setCommandName(cmd.getName());
        command.setDescription(cmd.getDescription());
        IParameter[] cmdParms = cmd.getParameters();
        if (cmdParms != null) {
            IParameter[] iParameterArray = cmdParms;
            int n = cmdParms.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter cmdParm = iParameterArray[n2];
                MCommandParameter parmModel = modelService.createModelElement(MCommandParameter.class);
                parmModel.setElementId(cmdParm.getId());
                parmModel.setName(cmdParm.getName());
                parmModel.setOptional(cmdParm.isOptional());
                ParameterType parmType = cmd.getParameterType(cmdParm.getId());
                if (parmType != null) {
                    parmModel.setTypeId(parmType.getId());
                }
                command.getParameters().add(parmModel);
                ++n2;
            }
        }
        return command;
    }

    @PostConstruct
    public void init() {
        Activator.trace("/trace/commands", "Initialize commands from model", null);
        this.undefinedCategory = this.commandService.defineCategory(MApplication.class.getName(), "Application Category", null);
        this.createCategories();
        this.createCommands();
        this.registerModelListeners();
        this.registerCommandListener();
    }

    @PreDestroy
    public void dispose() {
        this.unregisterCommandListener();
        this.unregsiterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = new EventHandler(){

            public void handleEvent(Event event) {
                if (CommandProcessingAddon.this.application == event.getProperty("ChangedElement") && UIEvents.isADD(event)) {
                    for (Object obj : UIEvents.asIterable(event, "NewValue")) {
                        if (obj instanceof MCommand) {
                            CommandProcessingAddon.this.createCommand((MCommand)obj);
                            continue;
                        }
                        if (!(obj instanceof MCategory)) continue;
                        CommandProcessingAddon.this.createCategory((MCategory)obj);
                    }
                }
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/application/Application/commands/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/application/Application/categories/*", this.additionHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
    }

    private void registerCommandListener() {
        this.cmListener = new ICommandManagerListener(){

            public void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
                if (commandManagerEvent.isCommandChanged() && commandManagerEvent.isCommandDefined()) {
                    String commandId = commandManagerEvent.getCommandId();
                    if (CommandProcessingAddon.this.findCommand(commandId) != null) {
                        return;
                    }
                    Command command = commandManagerEvent.getCommandManager().getCommand(commandId);
                    if (command.getHandler() == null) {
                        command.setHandler(HandlerServiceImpl.getHandler((String)commandId));
                    }
                    try {
                        MCategory categoryModel = CommandProcessingAddon.this.findCategory(command.getCategory().getId());
                        MCommand createdCommand = CommandProcessingAddon.createCommand(command, CommandProcessingAddon.this.modelService, categoryModel);
                        CommandProcessingAddon.this.application.getCommands().add(createdCommand);
                    }
                    catch (NotDefinedException e) {
                        Activator.getDefault().getLogService().log(0, "Failed to create command " + commandId, (Throwable)e);
                    }
                }
            }
        };
        this.commandManager.addCommandManagerListener(this.cmListener);
    }

    private void unregisterCommandListener() {
        this.commandManager.removeCommandManagerListener(this.cmListener);
    }

    protected MCommand findCommand(String commandId) {
        for (MCommand cmd : this.application.getCommands()) {
            if (!commandId.equals(cmd.getElementId())) continue;
            return cmd;
        }
        return null;
    }

    protected MCategory findCategory(String id) {
        List categories = this.application.getCategories();
        for (MCategory cat : categories) {
            if (!id.equals(cat.getElementId())) continue;
            return cat;
        }
        return null;
    }

    private void createCommands() {
        for (MCommand cmdModel : this.application.getCommands()) {
            this.createCommand(cmdModel);
        }
    }

    private void createCommand(MCommand cmdModel) {
        IParameter[] parms = null;
        String id = cmdModel.getElementId();
        String name = this.localize(cmdModel.getCommandName(), (MApplicationElement)cmdModel);
        String desc = this.localize(cmdModel.getDescription(), (MApplicationElement)cmdModel);
        List modelParms = cmdModel.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            ArrayList<Parameter> parmList = new ArrayList<Parameter>();
            for (MCommandParameter cmdParm : modelParms) {
                ParameterType parameterType = null;
                if (cmdParm.getTypeId() != null && cmdParm.getTypeId().length() > 0) {
                    parameterType = this.commandManager.getParameterType(cmdParm.getTypeId());
                }
                parmList.add(new Parameter(cmdParm.getElementId(), cmdParm.getName(), null, parameterType, cmdParm.isOptional()));
            }
            parms = parmList.toArray(new Parameter[parmList.size()]);
        }
        Category cat = this.undefinedCategory;
        if (cmdModel.getCategory() != null) {
            cat = this.commandService.getCategory(cmdModel.getCategory().getElementId());
        }
        this.commandService.defineCommand(id, name, desc, cat, parms, (String)cmdModel.getPersistedState().get("HelpContextId"));
    }

    private void createCategories() {
        for (MCategory catModel : this.application.getCategories()) {
            this.createCategory(catModel);
        }
    }

    private void createCategory(MCategory catModel) {
        Category category = this.commandService.getCategory(catModel.getElementId());
        if (!category.isDefined()) {
            category.define(this.localize(catModel.getName(), (MApplicationElement)catModel), this.localize(catModel.getDescription(), (MApplicationElement)catModel));
        }
    }

    private String localize(String key, MApplicationElement modelElement) {
        if (key == null) {
            return null;
        }
        String localized = LocalizationHelper.getLocalized((String)key, (MApplicationElement)modelElement);
        return localized == null ? key : localized;
    }
}

