/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;

public class DatasetUtils {
    public static List<Dimension> getAllDimensions() {
        ArrayList<Dimension> res = new ArrayList<Dimension>();
        Collection datasets = TimeseriesServiceFactory.getService().getDatasets();
        for (Dataset dataset : datasets) {
            List dimensions = dataset.getDimensions();
            for (Dimension dimension : dimensions) {
                if (res.contains(dimension)) continue;
                res.add(dimension);
            }
        }
        return res;
    }

    public static List<Concept> getAllDimensionsConcepts() {
        ArrayList<Concept> res = new ArrayList<Concept>();
        Collection datasets = TimeseriesServiceFactory.getService().getDatasets();
        for (Dataset dataset : datasets) {
            List dimensions = dataset.getDimensions();
            for (Dimension dimension : dimensions) {
                Concept concept = dimension.getConcept();
                if (res.contains(concept)) continue;
                res.add(concept);
            }
        }
        return res;
    }
}

