/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept.selection;

import java.util.Collection;
import java.util.Observable;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class ParentRelationSelection
extends Observable {
    private Concept dimension = null;
    private Collection<Relationship> relatedRelationships;
    private Relationship selectedRelationship;

    public Concept getMainConcept() {
        return this.dimension;
    }

    public ParentRelationSelection(Concept dimension) {
        this.dimension = dimension;
        try {
            this.relatedRelationships = dimension.getParentRelationships();
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
    }

    public boolean hasSelectedRelationship() {
        return this.selectedRelationship != null;
    }

    public Relationship getSelectedRelationship() {
        return this.selectedRelationship;
    }

    public void setSelectedRelationship(Relationship selectedRelationship) {
        if (!this.relatedRelationships.contains(selectedRelationship)) {
            throw new IllegalAccessError();
        }
        this.selectedRelationship = selectedRelationship;
        this.setChanged();
        this.notifyObservers();
    }

    public int getSize() {
        if (this.relatedRelationships != null) {
            return this.relatedRelationships.size();
        }
        return 0;
    }

    public Concept getDimension() {
        return this.dimension;
    }

    public Collection<Relationship> getRelatedRelationships() {
        return this.relatedRelationships;
    }
}

