/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.persistence;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModel;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModel;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModelImpl;
import org.fao.fi.fishstat.core.model.reference.ReferenceObjectModel;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.impl.IDAttribute;
import org.fao.fi.fishstat.data.reference.api.management.ReferenceManagementServiceFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;

public class ReferencePersistenceService {
    private IProgressMonitor monitor;

    protected ReferencePersistenceService() {
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void removeMonitor() {
        this.monitor.done();
        this.monitor = null;
    }

    public Concept persistConcept(ConceptModel conceptModel) throws Exception {
        if (conceptModel.isNative()) {
            return this.alterConceptModel(conceptModel);
        }
        return this.persistNewConcept(conceptModel);
    }

    public Relationship persistConceptRelationship(ConceptRelationshipModel conceptRelationshipModel) throws Exception {
        if (conceptRelationshipModel.isNative()) {
            return this.alterConceptRelationshipModel(conceptRelationshipModel);
        }
        return this.persistNewConceptRelationship(conceptRelationshipModel);
    }

    public void persistCustomGroup(ReferenceObject customGroup, Identifier id) throws Exception {
        Concept custom_group_concept = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
        custom_group_concept.addObject(customGroup, id);
    }

    public CustomGroup persistCustomGroup(CustomGroupModelImpl customgroupModel) throws Exception {
        ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
        return null;
    }

    private Concept persistNewConcept(ConceptModel conceptModel) throws Exception {
        if (this.monitor != null) {
            this.monitor.beginTask("Saving concept...", conceptModel.getAttributesSize() + 2);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        ConceptDescriptor concept_descriptor = DescriptorsFactory.createConceptDescriptor((String)conceptModel.getAcronym(), (MultilingualString)conceptModel.getName().getInstance(), (MultilingualString)conceptModel.getDescription().getInstance(), null);
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createConcept(concept_descriptor);
        if (this.monitor != null) {
            this.monitor.internalWorked(1.0);
        }
        Concept concept = ReferenceServiceFactory.getService().getConcept(concept_descriptor.getAcronym());
        HashSet<AttributeDescriptor> descriptors = new HashSet<AttributeDescriptor>();
        if (concept != null) {
            for (ConceptAttributeModel attributeModel : conceptModel.getAttributes()) {
                if (!attributeModel.getAcronym().equals("ID")) {
                    descriptors.add(DescriptorsFactory.createAttributeDescriptor((Identifier)concept.getId(), (String)attributeModel.getAcronym(), (MultilingualString)attributeModel.getName().getInstance(), (MultilingualString)attributeModel.getDescription().getInstance(), (AttributeType)attributeModel.getType(), (short)attributeModel.getSize(), (short)attributeModel.getScale(), (boolean)attributeModel.isCodeAttribute(), (boolean)attributeModel.isNameAttribute()));
                }
                if (this.monitor == null) continue;
                this.monitor.internalWorked(1.0);
            }
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createAttributes(descriptors);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Concept.class);
        if (this.monitor != null) {
            this.monitor.done();
        }
        return concept;
    }

    private Concept alterConceptModel(ConceptModel conceptModel) throws Exception {
        Concept concept;
        if (this.monitor != null) {
            this.monitor.beginTask("Saving concept...", conceptModel.getAttributesSize() * 2 + 3);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        if (!(concept = (Concept)conceptModel.getInstance()).getName().equals((Object)conceptModel.getName())) {
            concept.setName(conceptModel.getName().getInstance());
        }
        if (!concept.getDescription().equals((Object)conceptModel.getDescription())) {
            concept.setDescription(conceptModel.getDescription().getInstance());
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        LinkedList<Attribute> toRemove = new LinkedList<Attribute>();
        for (Attribute attribute : ((Concept)conceptModel.getInstance()).getAttributes()) {
            if (conceptModel.hasAttribute(attribute.getAcronym())) {
                ConceptAttributeModel attributeModel = conceptModel.getAttribute(attribute.getAcronym());
                if (!attributeModel.isSynchronised()) {
                    this.alterAttribute(attributeModel);
                }
                if (this.monitor == null) continue;
                this.monitor.worked(1);
                continue;
            }
            toRemove.add(attribute);
        }
        for (Attribute attribute : toRemove) {
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeAttribute(attribute);
            if (this.monitor == null) continue;
            this.monitor.worked(1);
        }
        for (ConceptAttributeModel attributeModel : conceptModel.getAttributes()) {
            if (concept.getAttribute(attributeModel.getAcronym()) != null) continue;
            AttributeDescriptor attributeDescriptor = DescriptorsFactory.createAttributeDescriptor((Identifier)concept.getId(), (String)attributeModel.getAcronym(), (MultilingualString)attributeModel.getName().getInstance(), (MultilingualString)attributeModel.getDescription().getInstance(), (AttributeType)attributeModel.getType(), (short)attributeModel.getSize(), (short)attributeModel.getScale(), (boolean)attributeModel.isCodeAttribute(), (boolean)attributeModel.isNameAttribute());
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createAttribute(attributeDescriptor);
            if (this.monitor == null) continue;
            this.monitor.worked(1);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Concept.class);
        return concept;
    }

    private void alterAttribute(ConceptAttributeModel attributeModel) {
        Attribute attribute = (Attribute)attributeModel.getInstance();
        if (!attribute.getName().equals((Object)attributeModel.getName())) {
            attribute.setName(attributeModel.getName().getInstance());
        }
        if (!attribute.getDescription().equals((Object)attributeModel.getDescription())) {
            attribute.setDescription(attributeModel.getDescription().getInstance());
        }
        if (!attribute.getType().equals((Object)attributeModel.getType())) {
            attribute.setType(attributeModel.getType());
        }
        if (attribute.isCodeAttribute() != attributeModel.isCodeAttribute()) {
            attribute.setCodeAttribute(attributeModel.isCodeAttribute());
        }
        if (attribute.isNameAttribute() != attributeModel.isNameAttribute()) {
            attribute.setNameAttribute(attributeModel.isNameAttribute());
        }
    }

    public void deleteConcept(Concept concept) throws Exception {
        if (this.monitor != null) {
            this.monitor.beginTask("Deleting concept...", 2);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeConcept(concept);
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Concept.class);
    }

    private Relationship alterConceptRelationshipModel(ConceptRelationshipModel conceptRelationshipModel) throws Exception {
        Relationship relationship;
        if (this.monitor != null) {
            this.monitor.beginTask("Saving relationship...", 5);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        if (!(relationship = (Relationship)conceptRelationshipModel.getInstance()).getName().equals((Object)conceptRelationshipModel.getName())) {
            relationship.setName(conceptRelationshipModel.getName().getInstance());
        }
        if (!relationship.getDescription().equals((Object)conceptRelationshipModel.getDescription())) {
            relationship.setDescription(conceptRelationshipModel.getDescription().getInstance());
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        if (!relationship.getChildConcept().equals(conceptRelationshipModel.getChild())) {
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeRelationship(relationship);
            this.persistNewConceptRelationship(conceptRelationshipModel);
        }
        if (!relationship.getParentConcept().equals(conceptRelationshipModel.getParent())) {
            ReferenceManagementServiceFactory.getReferenceMetadataManagementService().removeRelationship(relationship);
            this.persistNewConceptRelationship(conceptRelationshipModel);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Relationship.class);
        return relationship;
    }

    private Relationship persistNewConceptRelationship(ConceptRelationshipModel conceptRelationshipModel) throws Exception {
        if (this.monitor != null) {
            this.monitor.beginTask("Saving relationship...", 5);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        RelationshipDescriptor relationship_descriptor = DescriptorsFactory.createRelationshipDescriptor((String)conceptRelationshipModel.getAcronym(), (MultilingualString)conceptRelationshipModel.getName().getInstance(), (MultilingualString)conceptRelationshipModel.getDescription().getInstance(), (Identifier)conceptRelationshipModel.getParent().getId(), (Identifier)conceptRelationshipModel.getChild().getId(), null, (Integer)conceptRelationshipModel.getSortorder());
        Relationship relationship = ReferenceManagementServiceFactory.getReferenceMetadataManagementService().createRelationship(relationship_descriptor);
        if (this.monitor != null) {
            this.monitor.internalWorked(1.0);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Relationship.class);
        if (this.monitor != null) {
            this.monitor.done();
        }
        return relationship;
    }

    public ReferenceObject persistReference(ReferenceObjectModel referenceModel) {
        if (this.monitor != null) {
            this.monitor.beginTask("Saving reference object...", referenceModel.getAttributes().length + 3);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        ReferenceObject res = referenceModel.isNative() ? (ReferenceObject)referenceModel.getInstance() : referenceModel.getConcept().createObject();
        for (Attribute attribute : referenceModel.getConcept().getAttributes()) {
            if (attribute instanceof IDAttribute) continue;
            Object attval = referenceModel.getAttributeValue(attribute);
            if (res.getAttribute(attribute) != null && !res.getAttribute(attribute).equals(attval) || res.getAttribute(attribute) == null && attval != null) {
                if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                    res.setAttribute(attribute, (Object)new MultilingualString((MultilingualString)referenceModel.getAttributeValue(attribute)));
                } else {
                    res.setAttribute(attribute, referenceModel.getAttributeValue(attribute));
                }
            }
            if (this.monitor == null) continue;
            this.monitor.worked(1);
        }
        if (!referenceModel.isNative()) {
            referenceModel.getConcept().addObject(res);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(ReferenceObject.class);
        return res;
    }

    public void deleteReference(ReferenceObject referenceObject) throws Exception {
        if (this.monitor != null) {
            this.monitor.beginTask("Deleting reference object...", 2);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        referenceObject.getConcept().removeObject(referenceObject);
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(ReferenceObject.class);
    }
}

