/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.ResourceManager;
import org.fao.fi.fishstat.data.common.api.workspace.Workspace;
import org.fao.fi.fishstat.data.common.api.workspace.WorkspaceManager;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;
import org.fao.fi.fishstat.data.common.firestorm.FireStormHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class WorkspacesManager
extends Observable
implements ICoreConstants {
    public static final String MSG_OPEN_WORKSPACE = "MSG_OPEN_WORKSPACE";
    public static final String MSG_CLOSE_WORKSPACE = "MSG_CLOSE_WORKSPACE";
    public static final String MSG_REFRESH_WORKSPACE = "MSG_REFRESH_WORKSPACE";
    public static final String MSG_SCAN_REGISTRY = "MSG_SCAN_REGISTRY";
    private File root;
    private HashMap<String, WorkspaceModel> workspacesFolderRegistry = new HashMap(10);
    private WorkspaceModel currentWorkspace;

    public WorkspacesManager(String ws_path) {
        System.out.println("ROOT_WORKSPACES_FOLDER: " + ws_path);
        this.root = new File(ws_path);
        if (!this.root.exists()) {
            try {
                this.createRoot();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.rebuildWsRegistry();
        }
    }

    public void closeCurrentWorkspace() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace = null;
            this.setChanged();
            this.notifyObservers(MSG_CLOSE_WORKSPACE);
            ResourceManager.closeDriver();
            ClassLoaderFactory.dispose();
            Commons.fireMethodsMapReset();
            RegistryFactory.fireStructuralChangeEvents();
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {}
            System.gc();
        }
    }

    public void refreshMenuHandlers() {
        this.setChanged();
        System.out.println(MSG_REFRESH_WORKSPACE);
        this.notifyObservers(MSG_REFRESH_WORKSPACE);
    }

    public WorkspaceModel getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public List<WorkspaceModel> getDeployedWorkspaces() {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        File[] folders = this.root.listFiles();
        if (folders != null) {
            File[] fileArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File ws_folder = fileArray[n2];
                File ws_desc = new File(ws_folder, "ws.xml");
                if (ws_desc.exists() && ws_desc.isFile()) {
                    try {
                        WorkspaceModelImpl ws_md = new WorkspaceModelImpl(ws_desc);
                        if (CoreCommons.COMPATIBILITY.getMajor() >= ws_md.getCompatibility().getMajor()) {
                            res.add(new WorkspaceModelImpl(ws_desc));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return res;
    }

    public File getRoot() {
        return this.root;
    }

    public boolean hasCurrentWorkspace() {
        return this.currentWorkspace != null;
    }

    public boolean hasWorkspaceFolderRegistered(String ws_path) {
        return this.workspacesFolderRegistry.containsKey(ws_path);
    }

    public List<WorkspaceModel> getRegisteredWorkspaces(String ws_acronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(ws_acronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    private void openWorkspace(String ws_path) throws Exception {
        WorkspaceModel workspaceModel = this.getWorkspaceMeta(ws_path);
        ResourceManager.setJdbcDriver((String)workspaceModel.getDbDriver().getDriverClassName());
        ResourceManager.setJdbcUser((String)workspaceModel.getDbUsername());
        ResourceManager.setJdbcPassword((String)workspaceModel.getDbPassword());
        ResourceManager.setJdbcSchema((String)workspaceModel.getDbSchema());
        File ws_root = workspaceModel.getLocationDir();
        File jar_file = new File(String.valueOf(ws_root.getAbsolutePath()) + File.separator + "jar" + File.separator + "fishstatj-jdbc-dao.jar");
        File db_path = new File(workspaceModel.getLocationDir(), "db");
        if (jar_file.exists() && db_path.exists()) {
            Workspace ws = WorkspaceManager.instance().createWorkspace(workspaceModel.getDbUrl(), jar_file.toURI().toURL());
            WorkspaceManager.instance().setActiveWorkspace(ws);
        }
        System.out.println("JDBC URL: " + ResourceManager.getJdbcUrl());
        System.out.println("JDBC DRV: " + ResourceManager.getJdbcDriver());
        System.out.println("jar  URL: " + FireStormHelper.instance().getSrcDest());
        this.currentWorkspace = workspaceModel;
        this.setChanged();
        this.notifyObservers(MSG_OPEN_WORKSPACE);
    }

    public void registerWorkspace(String ws_path) throws Exception {
        File ws_desc;
        if (!this.workspacesFolderRegistry.containsKey(ws_path) && this.isWsDescriptorCompatible(ws_desc = new File(ws_path, "ws.xml"))) {
            WorkspaceModelImpl wmd = new WorkspaceModelImpl(ws_desc);
            this.workspacesFolderRegistry.put(ws_path, wmd);
        }
    }

    public boolean isWsDescriptorCompatible(File ws_descriptor) {
        if (ws_descriptor.exists() && ws_descriptor.isFile()) {
            WorkspaceModelImpl wmd = null;
            try {
                wmd = new WorkspaceModelImpl(ws_descriptor);
            }
            catch (Exception exception) {
                return false;
            }
            if (CoreCommons.COMPATIBILITY.getMajor() >= wmd.getCompatibility().getMajor()) {
                return true;
            }
        }
        return false;
    }

    public void switchWorkspace(String ws_path) throws Exception {
        if (this.currentWorkspace != null && !this.currentWorkspace.equals(ws_path)) {
            this.closeCurrentWorkspace();
        }
        this.openWorkspace(ws_path);
        ReferenceServiceFactory.getService().getConcept("PREDEFINED");
        CoreCommons.getWorkspaceStatus().setStatus(10);
    }

    public void reOpenCurrentWorkspace() throws Exception {
        String ws_path = this.currentWorkspace.getLocationDir().getAbsolutePath();
        this.closeCurrentWorkspace();
        this.openWorkspace(ws_path);
    }

    protected WorkspaceModel getWorkspaceMeta(String ws_folder) {
        return this.workspacesFolderRegistry.get(ws_folder);
    }

    public List<WorkspaceModel> getWorkspacesByAcronym(String ws_acronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(ws_acronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    public boolean isValidWorkspace(WorkspaceModel workspaceMetadata) {
        return this.workspacesFolderRegistry.containsValue(workspaceMetadata);
    }

    public boolean isValidWorkspacePath(String ws_path) {
        if (ws_path == null || ws_path.equals("")) {
            return false;
        }
        if (this.hasWorkspaceFolderRegistered(ws_path)) {
            return true;
        }
        return this.isWsDescriptorCompatible(new File(ws_path, "ws.xml"));
    }

    public int getNumberOfWorkspaces() {
        return this.workspacesFolderRegistry.size();
    }

    private void createRoot() throws Exception {
        boolean folder_created;
        if (!this.root.exists() && (folder_created = this.root.mkdir())) {
            System.out.println("Workspaces root successfully created");
        }
    }

    protected void rebuildWsRegistry() {
        List<WorkspaceModel> listMetadatas = this.getDeployedWorkspaces();
        this.workspacesFolderRegistry = new HashMap(listMetadatas.size());
        for (WorkspaceModel ws_meta : listMetadatas) {
            this.workspacesFolderRegistry.put(ws_meta.getLocationDir().getAbsolutePath(), ws_meta);
        }
        this.setChanged();
        this.notifyObservers(MSG_SCAN_REGISTRY);
    }

    public boolean isActiveWorkspaceDir(String dir) {
        if (dir == null) {
            return false;
        }
        if (dir.equals("")) {
            return false;
        }
        return this.workspacesFolderRegistry.containsKey(dir);
    }
}

