/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.data;

import com.csvreader.CsvReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.model.exchange.reference.ReferenceStructure;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructure;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructureElement;
import org.fao.fi.fishstat.core.workspaces.data.ReferenceCSVServiceWrapper;
import org.fao.fi.fishstat.core.workspaces.data.TimeSeriesCSVServiceWrapper;
import org.fao.fi.fishstat.core.workspaces.data.TimeSeriesImplWrapper;
import org.fao.fi.fishstat.core.workspaces.data.WorkspaceDataImporter;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.TSDException;
import org.fao.fi.fishstat.data.api.io.csv.DenormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.TimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.impl.DenormalisedTimeseriesCSVMetadataImpl;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;

public class WorkspaceDataImporterImpl
implements WorkspaceDataImporter {
    @Override
    public void validateTimeSeries(Reader reader, TimeSeriesStructure structure) throws Exception {
        switch (structure.getProtocol()) {
            case 1: {
                this.validateCsvTimeSeries(reader, structure);
                break;
            }
            default: {
                throw new Exception("Undefined protocol timeseries.");
            }
        }
    }

    private void validateCsvTimeSeries(Reader reader, TimeSeriesStructure structure) throws Exception {
        CsvReader csvReader = new CsvReader(reader);
        csvReader.readHeaders();
        this.checkHeaders(csvReader.getHeaders(), structure);
        csvReader.close();
    }

    private void checkHeaders(String[] headers, TimeSeriesStructure structure) throws TSDException {
        int structure_size = structure.getElements().size();
        if (headers.length < structure_size) {
            throw new TSDException("Numbers of columns too low respect this sctructure definition");
        }
        int i = 0;
        while (i < structure_size) {
            TimeSeriesStructureElement structureElement = structure.getElement(i);
            if (structureElement.getType() == 10 && !structureElement.getLabel().trim().toUpperCase(Locale.ENGLISH).equals(headers[i].trim().toUpperCase(Locale.ENGLISH))) {
                throw new TSDException("Columns [" + i + "] has an inconsistent header respect structure definition");
            }
            if (structureElement.getType() == 11 && structureElement.getCardinality() != 1) {
                int y = i;
                while (y < headers.length) {
                    structure.addDenormalizedPeriodColumn(this.identifyPeriod(headers[y]), y);
                    ++y;
                }
            }
            ++i;
        }
    }

    private ObservationPeriod identifyPeriod(String header) throws TSDException {
        int year;
        LinkedList<Integer> numbersFound = new LinkedList<Integer>();
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(header);
        while (m.find()) {
            numbersFound.add(Integer.parseInt(m.group()));
        }
        if (numbersFound.size() == 1 && (year = ((Integer)numbersFound.getFirst()).intValue()) > 1900 && year < 2100) {
            return ObservationPeriod.valueOf((String)("Y" + year));
        }
        return null;
    }

    @Override
    public void importTimeSeries(Reader reader, TimeSeriesStructure structure, IProgressMonitor monitor) throws Exception {
        if (structure == null) {
            throw new Exception("Undefined structure for timeseries.");
        }
        if (structure.getStructure() == 2) {
            DenormalisedTimeseriesCSVMetadata dTSMetadata = this.createDenormalisedTimeseriesCSVMetadata(structure);
            monitor.worked(5);
            TimeSeriesCSVServiceWrapper.instance().unMarshall(new TimeSeriesImplWrapper(structure.getTimeseries()), reader, (TimeseriesCSVMetadata)dTSMetadata, true, monitor);
        }
    }

    private DenormalisedTimeseriesCSVMetadata createDenormalisedTimeseriesCSVMetadata(TimeSeriesStructure structure) throws Exception {
        DenormalisedTimeseriesCSVMetadataImpl dTSMetadata = new DenormalisedTimeseriesCSVMetadataImpl(structure.getTimeseries());
        dTSMetadata.setUseHeaders(true);
        dTSMetadata.setTextQualifier('\"');
        for (TimeSeriesStructureElement element : structure.getElements()) {
            if (element.getType() == 10 && element.isPrimaryCode()) {
                dTSMetadata.setDimensionColumn(element.getDimension().getAcronym(), element.getIdx());
                dTSMetadata.setDimensionAttribute(element.getDimension().getAcronym(), element.getAttribute().getAcronym());
                dTSMetadata.setDimensionHeader(element.getDimension().getAcronym(), element.getLabel());
            }
            if (element.getType() != 11) continue;
            element.getCardinality();
            if (element.getCardinality() != 2) continue;
            int index = element.getIdx();
            for (ObservationPeriod period : structure.getObservationPeriods()) {
                dTSMetadata.setMeasureValueColumn(period.toString(), index);
                dTSMetadata.setMeasureValueHeader(period.toString(), period.getISO8601());
                dTSMetadata.setMeasureStatusHeader(period.toString(), null);
                dTSMetadata.setMeasureStatusColumn(period.toString(), -1);
            }
        }
        return dTSMetadata;
    }

    @Override
    public void importReferences(Reader reader, ReferenceStructure structure, IProgressMonitor monitor) throws Exception {
        ReferenceCSVServiceWrapper.instance().unMarshall(structure.getConcept(), reader, null, true, monitor);
    }
}

