/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.xmlbinds.workspaces;

import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructure;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.TSDException;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;

public class TimeSeriesStructureValidationEngine {
    protected void validateStructure(TimeSeriesStructure structure) throws TSDException {
        this.checkDatasetDimensions(structure);
        switch (structure.getProtocol()) {
            case 1: {
                this.validateCSVStructure(structure);
                break;
            }
            case 10: {
                this.validateXMLStructure(structure);
                break;
            }
            case 20: {
                this.validateSDMXCompactStructure(structure);
                break;
            }
        }
    }

    private void validateCSVStructure(TimeSeriesStructure structure) throws TSDException {
    }

    private void validateXMLStructure(TimeSeriesStructure structure) throws TSDException {
    }

    private void validateSDMXCompactStructure(TimeSeriesStructure structure) throws TSDException {
    }

    private void checkDatasetDimensions(TimeSeriesStructure structure) throws TSDException {
        for (Dimension dimension : structure.getDataset().getDimensions()) {
            Attribute dimensionAttribute;
            Concept dimensionConcept = dimension.getConcept();
            if (structure.hasDimensionElement(dimensionConcept, dimensionAttribute = dimension.getAttribute())) continue;
            throw new TSDException("Missing structure element. Concept: " + dimensionConcept.getAcronym() + " - Attribute " + dimensionAttribute.getAcronym());
        }
    }
}

