/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscovery;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.PackagingTypeMappingConfiguration;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;

public class LifecycleMappingDiscoveryHelper {
    private LifecycleMappingDiscoveryHelper() {
    }

    public static LifecycleMappingDiscoveryRequest createLifecycleMappingDiscoveryRequest(IProject project, IProgressMonitor monitor) throws CoreException {
        return LifecycleMappingDiscoveryHelper.createLifecycleMappingDiscoveryRequest(Collections.singleton(project), monitor);
    }

    public static LifecycleMappingDiscoveryRequest createLifecycleMappingDiscoveryRequest(Collection<IProject> projects, IProgressMonitor monitor) throws CoreException {
        LifecycleMappingDiscoveryRequest request = new LifecycleMappingDiscoveryRequest();
        if (projects != null) {
            for (IProject p : projects) {
                IMavenProjectFacade facade;
                IMarker[] lifecycleMappingMarkers;
                if (!p.isAccessible() || !p.hasNature("org.eclipse.m2e.core.maven2Nature") || (lifecycleMappingMarkers = LifecycleMappingDiscoveryHelper.getLifecycleMappingMarkers(p)) == null || lifecycleMappingMarkers.length <= 0 || (facade = LifecycleMappingDiscoveryHelper.getFacade(p, monitor)) == null) continue;
                IMarker[] iMarkerArray = lifecycleMappingMarkers;
                int n = lifecycleMappingMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    ILifecycleMappingRequirement req = LifecycleMappingDiscoveryHelper.toLifecycleMappingRequirement(m, facade.getPackaging());
                    if (req != null) {
                        request.addProject(facade, req);
                    }
                    ++n2;
                }
            }
        }
        return request;
    }

    private static ILifecycleMappingRequirement toLifecycleMappingRequirement(IMarker marker, String packagingType) {
        String type = marker.getAttribute("editor_hint", null);
        if (type == null) {
            return null;
        }
        MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement requirement = null;
        if ("not_covered_mojo_execution".equals(type)) {
            MojoExecutionKey mek = MarkerUtils.getMojoExecution((IMarker)marker);
            if (mek != null) {
                requirement = new MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement(mek, packagingType);
            }
        } else if ("unknown_lifecycle_id".equals(type)) {
            String lifecycleId = LifecycleMappingDiscoveryHelper.getLifecycleId(marker);
            if (lifecycleId != null) {
                requirement = new PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement(null, lifecycleId);
            }
        } else if ("missing_configurator".equals(type)) {
            String configuratorId = LifecycleMappingDiscoveryHelper.getConfiguratorId(marker);
            MojoExecutionKey mek = MarkerUtils.getMojoExecution((IMarker)marker);
            if (configuratorId != null) {
                requirement = new MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement(mek, configuratorId);
            }
        }
        return requirement;
    }

    private static IMarker[] getLifecycleMappingMarkers(IProject p) throws CoreException {
        IMarker[] markers = p.findMarkers("org.eclipse.m2e.core.maven2Problem.lifecycleMapping", true, 1);
        return markers;
    }

    public static void discoverProposals(LifecycleMappingDiscoveryRequest discoveryRequest, IProgressMonitor monitor) throws CoreException {
        if (discoveryRequest == null || discoveryRequest.getRequirements() == null || discoveryRequest.getRequirements().isEmpty()) {
            return;
        }
        IMavenDiscovery discoveryService = M2EUIPluginActivator.getDefault().getMavenDiscovery();
        if (discoveryService == null) {
            return;
        }
        Collection requirements = discoveryRequest.getRequirements();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.MavenImportWizard_searchingTaskTitle, requirements.size());
        Map allProposals = discoveryService.discover(requirements, discoveryRequest.getSelectedProposals(), monitor);
        discoveryRequest.setProposals(allProposals);
        monitor.worked(1);
    }

    private static IMavenProjectFacade getFacade(IProject project, IProgressMonitor monitor) {
        return MavenPlugin.getMavenProjectRegistry().create(project.getFile("pom.xml"), true, monitor);
    }

    private static String getLifecycleId(IMarker marker) {
        return marker.getAttribute("lifecyclePhase", null);
    }

    private static String getConfiguratorId(IMarker marker) {
        return marker.getAttribute("configuratorId", null);
    }
}

