/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.model.functions;

import java.util.Arrays;
import java.util.Observable;
import java.util.Vector;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;

public class ParameterWrapper
extends Observable {
    private Parameter parameter;
    private String value;
    private Vector<String> enumeratedValues;
    private boolean valid;

    public ParameterWrapper(Parameter parameter, String value) {
        this.parameter = parameter;
        if (parameter.getEnumeratedValues() != null) {
            this.enumeratedValues = new Vector<String>(Arrays.asList(parameter.getEnumeratedValues()));
        }
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.chkValue();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public Vector<String> getEnumeratedValues() {
        return this.enumeratedValues;
    }

    public boolean hasEnumeratedValues() {
        return this.enumeratedValues != null;
    }

    private void chkValue() {
        this.valid = this.parameter.isValid(this.value);
    }

    public boolean isValid() {
        return this.valid;
    }
}

