/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.session;

import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierImpl;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.model.selection.GuiFilterWrapper;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlSessionPersister {
    private DocumentBuilderFactory documentBuilderFactory;
    private DocumentBuilder documentBuilder;
    private CoreRegistry registry;
    private File xmlfile;

    public XmlSessionPersister(WorkspaceModel workspace) {
        try {
            this.registry = GuiCoreActivator.getDefault().getRegistry();
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.xmlfile = new File(workspace.getSessionDir(), "session.xml");
        }
        catch (Exception exception) {}
    }

    public void persist() throws Exception {
        if (this.xmlfile.exists()) {
            this.xmlfile.delete();
        }
        Document doc = this.documentBuilder.newDocument();
        Element workspaceSessionElement = doc.createElement("workspace-session");
        workspaceSessionElement.setAttribute("workspace_id", "0");
        int i = 0;
        while (i < this.registry.getOpenSessionsSize()) {
            this.persistSession(doc, workspaceSessionElement, (Session)this.registry.getOpenSessions().get(i), i);
            ++i;
        }
        doc.appendChild(workspaceSessionElement);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.setOutputProperty("indent", "yes");
        FileWriter xmlWriter = new FileWriter(this.xmlfile);
        StreamResult result = new StreamResult(xmlWriter);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        xmlWriter.flush();
        xmlWriter.close();
    }

    private void persistSession(Document doc, Element root, Session session, int id) {
        Element activitySessionElement = doc.createElement("activity-session");
        activitySessionElement.setAttribute("id", Integer.toString(id));
        activitySessionElement.setAttribute("uuid", session.getUUID());
        activitySessionElement.setAttribute("dataset_id", session.getDataset().getId().stringValue());
        activitySessionElement.setAttribute("dataset_acronym", session.getDataset().getAcronym());
        activitySessionElement.setAttribute("timeseries_id", session.getTimeseries().getId().stringValue());
        activitySessionElement.setAttribute("timeseries_acronym", session.getTimeseries().getAcronym());
        if (session.hasFilterRequest()) {
            this.persistFilter(doc, activitySessionElement, session);
        }
        if (session.hasAggregationRequest()) {
            this.persistAggregation(doc, activitySessionElement, session);
        }
        if (session.hasTopCriteriaRequest()) {
            this.persistTopCriteria(doc, activitySessionElement, session);
        }
        root.appendChild(activitySessionElement);
    }

    private void persistFilter(Document doc, Element root, Session session) {
        Element filterElement = doc.createElement("filter");
        FilterWrapper fw = session.getFilterRequest();
        int i = 0;
        while (i < fw.size()) {
            ConceptSelection conceptSelection = fw.getConceptSelection(i);
            Element dimensionElement = doc.createElement("dimension");
            dimensionElement.setAttribute("acronym", conceptSelection.getConcept().getAcronym());
            dimensionElement.setAttribute("id", conceptSelection.getConcept().getId().stringValue());
            Element includesElement = doc.createElement("includes");
            includesElement.appendChild(doc.createTextNode(CoreUtils.toCsv((Set)conceptSelection.getIncludes())));
            dimensionElement.appendChild(includesElement);
            filterElement.appendChild(dimensionElement);
            ++i;
        }
        root.appendChild(filterElement);
    }

    private void persistAggregation(Document doc, Element root, Session session) {
        Element aggregationElement = doc.createElement("aggregation");
        AggregationWrapper aw = session.getAggregationRequest();
        aggregationElement.appendChild(doc.createComment("Types: 0-Detailed; 1-Grouped Basic 2-Grouped Handpicked 3-Aggregated"));
        int i = 0;
        while (i < aw.size()) {
            DimensionAggregation dimensionAggregation = aw.getDimensionAggregation(i);
            Element dimensionElement = doc.createElement("dimension");
            dimensionElement.setAttribute("id", dimensionAggregation.getDimension().getId().stringValue());
            dimensionElement.setAttribute("acronym", dimensionAggregation.getDimension().getAcronym());
            dimensionElement.setAttribute("aggregation-type", Integer.toString(dimensionAggregation.getType()));
            aggregationElement.appendChild(dimensionElement);
            Enumeration includeParents = dimensionAggregation.getIncludeParents();
            if (includeParents.hasMoreElements()) {
                while (includeParents.hasMoreElements()) {
                    Element itemElement = doc.createElement("aggregator");
                    Concept concept = (Concept)includeParents.nextElement();
                    itemElement.setAttribute("concept-id", concept.getId().stringValue());
                    itemElement.setAttribute("concept-acronym", concept.getAcronym());
                    itemElement.appendChild(doc.createTextNode(CoreUtils.toCsv((Set)dimensionAggregation.getIncludes(concept))));
                    dimensionElement.appendChild(itemElement);
                }
            }
            ++i;
        }
        root.appendChild(aggregationElement);
    }

    private void persistTopCriteria(Document doc, Element root, Session session) {
        Element topCriteriaElement = doc.createElement("topcriteria");
        TopCriteriaWrapper tw = session.getTopOthersRequest();
        topCriteriaElement.setAttribute("type", tw.getCriteriaType().toString());
        if (tw.getType() == 1) {
            topCriteriaElement.setAttribute("by", "period");
            topCriteriaElement.appendChild(doc.createTextNode(tw.getPeriod_id()));
        } else {
            topCriteriaElement.setAttribute("by", "function");
            topCriteriaElement.appendChild(doc.createTextNode(tw.getCalcColName()));
        }
        topCriteriaElement.setAttribute("top", Integer.toString(tw.getValue()));
        root.appendChild(topCriteriaElement);
    }

    public Session[] retrieve() throws Exception {
        if (!this.xmlfile.exists()) {
            return new Session[0];
        }
        Document doc = this.documentBuilder.parse(this.xmlfile);
        Element rootElement = doc.getDocumentElement();
        NodeList nodeList = rootElement.getElementsByTagName("activity-session");
        Session[] res = new Session[nodeList.getLength()];
        int s = 0;
        while (s < res.length) {
            Element activitySessionElement = (Element)nodeList.item(s);
            res[s] = this.retrieveActivitySession(activitySessionElement);
            ++s;
        }
        return res;
    }

    private Session retrieveActivitySession(Element activitySessionElement) throws Exception {
        NodeList topCriteriaNodeList;
        NodeList aggregationNodeList;
        GuiSession res = null;
        String dataset_acronym = activitySessionElement.getAttribute("dataset_acronym");
        String timeseries_acronym = activitySessionElement.getAttribute("timeseries_acronym");
        Timeseries ts = TimeseriesServiceFactory.getService().getDataset(dataset_acronym).getTimeseries(timeseries_acronym);
        SessionDescriptor descriptor = new SessionDescriptor(activitySessionElement.getAttribute("uuid"));
        descriptor.setTimeseries(ts);
        descriptor.setId(Integer.parseInt(activitySessionElement.getAttribute("id")));
        res = new GuiSession(descriptor);
        NodeList filterNodeList = activitySessionElement.getElementsByTagName("filter");
        if (filterNodeList.getLength() == 1) {
            Element filterElement = (Element)filterNodeList.item(0);
            res.setFilterRequest(this.retrieveFilterWrapper(filterElement, res));
        }
        if ((aggregationNodeList = activitySessionElement.getElementsByTagName("aggregation")).getLength() == 1) {
            Element aggregationElement = (Element)aggregationNodeList.item(0);
            res.setAggregationRequest(this.retrieveAggregationWrapper(aggregationElement, res));
        }
        if ((topCriteriaNodeList = activitySessionElement.getElementsByTagName("topcriteria")).getLength() == 1) {
            Element topCriteriaElement = (Element)topCriteriaNodeList.item(0);
            res.setTopOthersRequest(this.retrieveTopCriteriaWrapper(topCriteriaElement, res));
        }
        return res;
    }

    private FilterWrapper retrieveFilterWrapper(Element filterElement, GuiSession session) throws Exception {
        GuiFilterWrapper res = new GuiFilterWrapper(session);
        NodeList dimensionList = filterElement.getElementsByTagName("dimension");
        int d = 0;
        while (d < dimensionList.getLength()) {
            Element dimensionElement = (Element)dimensionList.item(d);
            ConceptSelection conceptSelection = res.getConceptSelection(dimensionElement.getAttribute("acronym"));
            Concept concept = ReferenceServiceFactory.getService().getConcept(IdentifierFactory.instance((String)dimensionElement.getAttribute("id")));
            ReferenceObject[] includes = CoreUtils.fromCsv((Concept)concept, (String)dimensionElement.getTextContent());
            if (includes.length > 0) {
                conceptSelection.addIncludes(includes);
            }
            ++d;
        }
        return res;
    }

    private AggregationWrapper retrieveAggregationWrapper(Element aggregationElement, GuiSession session) throws Exception {
        AggregationWrapper res = new AggregationWrapper((Session)session);
        NodeList dimensionList = aggregationElement.getElementsByTagName("dimension");
        int d = 0;
        while (d < dimensionList.getLength()) {
            Element dimensionElement = (Element)dimensionList.item(d);
            DimensionAggregation dimensionAggregation = res.getDimensionAggregation(dimensionElement.getAttribute("acronym"));
            if (dimensionAggregation != null) {
                int agg_type = Integer.parseInt(dimensionElement.getAttribute("aggregation-type"));
                switch (agg_type) {
                    case 0: {
                        dimensionAggregation.setDetailedDimension();
                        break;
                    }
                    case 1: {
                        Element basicAggregatorElement = (Element)dimensionElement.getElementsByTagName("aggregator").item(0);
                        Concept concept = ReferenceServiceFactory.getService().getConcept(IdentifierFactory.instance((String)basicAggregatorElement.getAttribute("concept-id")));
                        dimensionAggregation.setBasicConceptAggregation(concept);
                        break;
                    }
                    case 2: {
                        NodeList hpAggregatorList = dimensionElement.getElementsByTagName("aggregator");
                        int a = 0;
                        while (a < hpAggregatorList.getLength()) {
                            ReferenceObject[] includes;
                            Element hpAggregatorElement = (Element)hpAggregatorList.item(a);
                            Concept hpConcept = ReferenceServiceFactory.getService().getConcept(IdentifierFactory.instance((String)hpAggregatorElement.getAttribute("concept-id")));
                            ReferenceObject[] referenceObjectArray = includes = CoreUtils.fromCsv((Concept)hpConcept, (String)hpAggregatorElement.getTextContent());
                            int n = includes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ReferenceObject referenceObject = referenceObjectArray[n2];
                                dimensionAggregation.addIncluded(referenceObject, false);
                                ++n2;
                            }
                            dimensionAggregation.notifyObservers();
                            ++a;
                        }
                        break;
                    }
                    case 3: {
                        dimensionAggregation.setAggregatedDimension();
                        break;
                    }
                }
            }
            ++d;
        }
        return res;
    }

    private TopCriteriaWrapper retrieveTopCriteriaWrapper(Element topCriteriaElement, Session session) throws Exception {
        TopCriteriaWrapper res = new TopCriteriaWrapper(session);
        String by = topCriteriaElement.getAttribute("by");
        String type = topCriteriaElement.getAttribute("type");
        res.setCriteriaType(TopCriteria.CriteriaType.valueOf((String)type));
        res.setValue(Integer.parseInt(topCriteriaElement.getAttribute("top")));
        if (by.equals("period")) {
            res.setPeriod_id(topCriteriaElement.getTextContent());
        } else {
            res.setCalcmd_name(topCriteriaElement.getTextContent());
        }
        Dimension dimension = session.getDataset().getObservedMeasureDimension();
        if (dimension != null) {
            String measure_id = topCriteriaElement.getAttribute("measure");
            res.setMeasure(dimension.getConcept().getObject((Identifier)new IdentifierImpl(measure_id)));
        }
        return res;
    }
}

