/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.maven.index.ArtifactInfo;

public class NexusLegacyAnalyzer
extends Analyzer {
    private static Analyzer DEFAULT_ANALYZER = new StandardAnalyzer();

    public TokenStream tokenStream(String field, Reader reader) {
        if (!this.isTextField(field)) {
            return new CharTokenizer(reader){

                protected boolean isTokenChar(char c) {
                    return Character.isLetterOrDigit(c);
                }

                protected char normalize(char c) {
                    return Character.toLowerCase(c);
                }
            };
        }
        return DEFAULT_ANALYZER.tokenStream(field, reader);
    }

    public TokenStream reusableTokenStream(String field, Reader reader) throws IOException {
        if (!this.isTextField(field)) {
            return new CharTokenizer(reader){

                protected boolean isTokenChar(char c) {
                    return Character.isLetterOrDigit(c);
                }

                protected char normalize(char c) {
                    return Character.toLowerCase(c);
                }
            };
        }
        return DEFAULT_ANALYZER.reusableTokenStream(field, reader);
    }

    protected boolean isTextField(String field) {
        return ArtifactInfo.NAME.equals(field) || ArtifactInfo.DESCRIPTION.equals(field) || ArtifactInfo.NAMES.equals(field);
    }
}

