/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.packer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codehaus.plexus.util.IOUtil;

public class DigesterUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDigest(String alg, InputStream is) throws NoSuchAlgorithmException {
        String result = null;
        try {
            try {
                int numRead;
                byte[] buffer = new byte[1024];
                MessageDigest md = MessageDigest.getInstance(alg);
                do {
                    if ((numRead = is.read(buffer)) <= 0) continue;
                    md.update(buffer, 0, numRead);
                } while (numRead != -1);
                result = new String(DigesterUtils.encodeHex(md.digest()));
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static String getSha1Digest(String content) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes("UTF-8"));
            return DigesterUtils.getDigest("SHA1", fis);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getSha1Digest(InputStream is) {
        try {
            return DigesterUtils.getDigest("SHA1", is);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getSha1Digest(File file) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = DigesterUtils.getDigest("SHA1", fis);
        }
        catch (NoSuchAlgorithmException e) {
            String string2 = null;
            IOUtil.close((InputStream)fis);
            return string2;
        }
        catch (FileNotFoundException e2) {
            String string3 = null;
            {
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)fis);
            return string3;
        }
        IOUtil.close((InputStream)fis);
        return string;
    }

    public static String getMd5Digest(String content) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes("UTF-8"));
            return DigesterUtils.getDigest("MD5", fis);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getMd5Digest(InputStream is) {
        try {
            return DigesterUtils.getDigest("MD5", is);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getMd5Digest(File file) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = DigesterUtils.getDigest("MD5", fis);
        }
        catch (NoSuchAlgorithmException e) {
            String string2 = null;
            IOUtil.close((InputStream)fis);
            return string2;
        }
        catch (FileNotFoundException e2) {
            String string3 = null;
            {
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)fis);
            return string3;
        }
        IOUtil.close((InputStream)fis);
        return string;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

